<?php
/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

defined('ABSPATH') or die('No script kiddies please!');

class VA_EY4WP_Admin {

    private static $short_code_id = 0;

    /**
     * Add Menuitems
     */
    public static function build_menu() {
        if (!is_admin()) {
            return;
        }

        //menu items
        add_menu_page('eyepin', esc_html__('eyepin', 'eyepin'), 'manage_options', 'eyepin-for-wp', array(__CLASS__, 'management'), esc_url(VA_EY4WP_PLUGIN_URL) . 'admin/img/icon-eyepin.svg', 93.65);
        add_submenu_page('eyepin-for-wp', 'eyepin - ', esc_html__('Formulare', 'eyepin'), 'manage_options', 'eyepin-for-wp-forms', array(__CLASS__, 'forms'));

        //add settings link
        add_filter('plugin_action_links_' . esc_url(VA_EY4WP_PLUGIN_NAME) . '/' . esc_url(VA_EY4WP_PLUGIN_NAME) . '.php', array(__CLASS__, 'plugin_settings_link'));
    }

    /**
     * Register form actions
     */
    public function register_admin_actions() {

    }

    // Add settings link on plugin page
    public static function plugin_settings_link($links) {
        $settings_link = '<a href="admin.php?page=' . esc_url(VA_EY4WP_PLUGIN_NAME) . '">' . esc_html__('Einstellungen', 'eyepin') . '</a>';

        array_unshift($links, $settings_link);
        return $links;
    }

    /**
     * Display the settings page
     */
    public static function management() {
        $action = filter_input(INPUT_POST, VA_EY4WP_PLUGIN_NAME . '-action', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $error = '';
        $message = '';
        $error_client = '';
        $message_client = '';
        $message_overwriteAddress = '';
        $error_overwriteAddress = '';
        if (isset($action) && strlen($action) > 5) {
            if (strcmp($action, VA_EY4WP_PLUGIN_NAME . '-settings-form-submit') == 0) {
                $username = filter_input(INPUT_POST, 'eyepin_username', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
                $password = filter_input(INPUT_POST, 'eyepin_password', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
                if (strlen($username) > 3 && strlen($password) > 3 && $password != '******') {
                    $securedPassword = VA_EY4WP_Utility_Helper::encrypt($password, AUTH_KEY);
                    update_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', $username, false);
                    update_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', $securedPassword, false);
                    $message = esc_html__('Daten wurden erfolgreich gespeichert!', 'eyepin');
                    $error = 'success';
                } else {
                    $message = esc_html__('Geben Sie alle nötigen Daten ein!', 'eyepin');
                    $error = 'error';
                }
            } else if (strcmp($action, VA_EY4WP_PLUGIN_NAME . '-settings-client-form-submit') == 0) {
                $client = filter_input(INPUT_POST, 'eyepin_client', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
                update_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_client', $client, false);
                $message_client = esc_html__('Daten wurden erfolgreich gespeichert!', 'eyepin');
                $error_client = 'success';
            } else if (strcmp($action, VA_EY4WP_PLUGIN_NAME . '-settings-overwriteaddress-form-submit') == 0) {

                $overwriteAddress = filter_input(INPUT_POST, 'eyepin_addressoverwrite', FILTER_SANITIZE_FULL_SPECIAL_CHARS);

                global $wpdb;
                $tableName = $wpdb->prefix . VA_EY4WP_Admin_Pages::TABLE_NAME;

                $tableData = array(
                    'name' => 'overwrite_address',
                    'value' => $overwriteAddress
                );


                //$result = $wpdb->insert($tableName, $tableData);

                $result = $wpdb->replace($tableName, $tableData); // phpcs:ignore WordPress.DB.DirectDatabaseQuery

                if ($result){
                    $message_overwriteAddress = esc_html__('Daten wurden erfolgreich gespeichert!', 'eyepin');
                    $error_overwriteAddress = 'success';
                } else {
                    $message_overwriteAddress = esc_html__('Speichern der Einstellung fehlgeschlagen!', 'eyepin');
                    $error_overwriteAddress = 'error';
                }


            } else {
                $message_client = esc_html__('Geben Sie alle nötigen Daten ein!', 'eyepin');
                $error_client = 'error';
            }
        }
        VA_EY4WP_Admin_Pages::show_settings_form($message, $error, $message_client, $error_client, $message_overwriteAddress, $error_overwriteAddress);
    }

    /**
     * Display the forms page
     */
    public static function forms() {
        //check if form is sent
        if (filter_input(INPUT_POST, 'form_name') != NULL) {
            if (!wp_verify_nonce(filter_input(INPUT_POST, '_wpnonce'), 'eyepin-for-wp-form-form')) {
                die('Failed security check');
            }
            $formName = filter_input(INPUT_POST, 'form_name');
            $messageSent = filter_input(INPUT_POST, 'message-sent');
            $messageNotSent = filter_input(INPUT_POST, 'message-not-sent');
            $messageFieldError = filter_input(INPUT_POST, 'message-field-error');
            $messageFieldAlreadyExists = filter_input(INPUT_POST, 'message-field-already-exists');
            $messageRecaptchaNotCorrect = filter_input(INPUT_POST, 'message-recaptcha-incorrect');
            $form = filter_input(INPUT_POST, 'eypepin-for-wp-form-fields');
            $form_eyepin = filter_input(INPUT_POST, 'form-optin-eyepin');
            $form_id = filter_input(INPUT_POST, 'wordpress-for-eypin-form-id');
            $site_key = filter_input(INPUT_POST, 'recaptcha-sitekey');
            $secret_key = filter_input(INPUT_POST, 'recaptcha-secretkey');
            $re_captcha_version_type = filter_input(INPUT_POST, 'recaptcha-version-select');
            $v2_checkbox_is_checked = filter_input(INPUT_POST, 'recaptcha-v2-display-checkbox');
            $score = filter_input(INPUT_POST, 'recaptcha-v3-score');

            global $wpdb;
            $tableName = $wpdb->prefix . VA_EY4WP_Admin_Forms::TABLE_NAME;

            $tableData = array(
                'name' => $formName,
                'message_sent' => $messageSent,
                'message_not_sent' => $messageNotSent,
                'message_field_error' => $messageFieldError,
                'message_field_already_exists' => $messageFieldAlreadyExists,
                'message_recaptcha_incorrect' => $messageRecaptchaNotCorrect,
                'form' => $form,
                'site_key' => $site_key,
                'secret_key' => $secret_key,
                'opt_in' => $form_eyepin,
                're_captcha_version_type' => $re_captcha_version_type,
                'v2_checkbox_is_checked' => $v2_checkbox_is_checked,
                'score' => $score
            );

            if ($form_id == NULL) {
                $wpdb->insert($tableName, $tableData); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
            } else {
                $wpdb->update($tableName, $tableData, array('id' => $form_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
            }

            //redirect to overview
            $formsTable = new VA_EY4WP_Admin_Forms();
            $formsTable->render();
            return;
        }

        if (filter_input(INPUT_GET, 'action')) {
            if (strcmp(filter_input(INPUT_GET, 'action'), 'new') == 0) {
                //add new form
                $newForm = new VA_EY4WP_Admin_Form();
                $newForm->display();
                return;
            } else if (strcmp(filter_input(INPUT_GET, 'action'), 'edit') == 0) {
                //show edit form
                $id = filter_input(INPUT_GET, 'form_id');
                $newForm = new VA_EY4WP_Admin_Form();
                $newForm->display($id);
                return;
            }
        }

        $formsTable = new VA_EY4WP_Admin_Forms();
        $formsTable->render();
    }

    public static function load_header_script() {
        $id = self::$short_code_id;
        $form = VA_EY4WP_Utility_Helper::getFormForId($id);
        $isRecaptchaV3 = $form->re_captcha_version_type === 'v3';

        // Check if it's Recaptcha v3
        if (!$isRecaptchaV3) {
            // Register and enqueue Google Recaptcha v2
            wp_register_script('google-recaptcha-v2', 'https://www.google.com/recaptcha/api.js?hl=de', array(), VA_EY4WP_PLUGIN_VERSION, false);
            wp_enqueue_script('google-recaptcha-v2');
        } else {
            $site_key = !empty($form->site_key) ? $form->site_key : '';
            // Register and enqueue Google Recaptcha v3
            wp_register_script('google-recaptcha-v3', 'https://www.google.com/recaptcha/api.js?hl=de&render=' . $site_key, array(), VA_EY4WP_PLUGIN_VERSION, false);
            wp_enqueue_script('google-recaptcha-v3');
        }
    }

    public static function load_footer_script() {
        $id = self::$short_code_id;
        $form = VA_EY4WP_Utility_Helper::getFormForId($id);
        $site_key = !empty($form->site_key) ? $form->site_key : '';

        if(!empty($site_key)) {
            wp_register_script('shortcode-js-footer', VA_EY4WP_PLUGIN_URL . 'admin/js/shortcode-footer.js', array(), VA_EY4WP_PLUGIN_VERSION, true);
            wp_enqueue_script('shortcode-js-footer');

            wp_localize_script('shortcode-js-footer', 'site_key_data', array(
                'siteKey' => $site_key
            ));
        }
    }

    /**
     * Add all needed Hooks for the admin page
     */
    public function add_hooks() {
        //menu
        add_action('admin_menu', array(__CLASS__, 'build_menu'));

        //for custom posts action
        add_action('admin_footer-edit.php', array(__CLASS__, 'custom_bulk_admin_footer'));
        add_action('load-edit.php', array(__CLASS__, 'custom_bulk_action'));
        add_action('admin_notices', array(__CLASS__, 'custom_bulk_admin_notices'));

        //custom post column
        add_filter('manage_posts_columns', array(__CLASS__, 'columns_head'));
        add_action('manage_posts_custom_column', array(__CLASS__, 'columns_content'), 10, 2);
//        add_action('wp_head', array(__CLASS__, 'load_header_script'));
        add_action('wp_enqueue_scripts', array(__CLASS__, 'load_header_script'));
        add_action('wp_footer', array(__CLASS__, 'load_footer_script'));


        //register cf7 integration
        $integration = new VA_EY4WP_Integration();
        $integration->add_hooks();
    }

    /**
     * Handles the Shortcode for forms
     * @param type $atts
     */
    public static function handle_eyepin_form_shortcode($atts) {
        $attributes = shortcode_atts(array(
            'name' => '',
            'id' => '',
        ), $atts);

        self::$short_code_id = $attributes['id'];

        $shortcode = new VA_EY4WP_Utility_Shortcodehandler();
        ob_start();
        $shortcode->display($attributes['id']);
        $html = ob_get_clean();
        return $html;
    }

    /**
     * Register needed shortcode
     */
    public function add_shortcodes() {
        add_shortcode('eyepin_for_wp', array(__CLASS__, 'handle_eyepin_form_shortcode'));
    }

    /**
     * Regsiter neeeded Admin Scripts
     */
    public static function load_admin_scripts() {
        wp_register_style('codemirror_css', includes_url('/js/codemirror/codemirror.min.css'), array(), VA_EY4WP_PLUGIN_VERSION);
        wp_register_style('admin_css', VA_EY4WP_PLUGIN_URL . 'admin/css/style.css', array(), VA_EY4WP_PLUGIN_VERSION);
        wp_register_script('admin_js', VA_EY4WP_PLUGIN_URL . 'admin/js/admin.js', array(), VA_EY4WP_PLUGIN_VERSION);
        wp_register_script('codemirror_js', includes_url('/js/codemirror/codemirror.min.js'), array(), VA_EY4WP_PLUGIN_VERSION);
        wp_register_script('codemirror_xml_js', VA_EY4WP_PLUGIN_URL . 'lib/xml.js', array(), VA_EY4WP_PLUGIN_VERSION);
        wp_enqueue_style('codemirror_css');
        wp_enqueue_style('admin_css');
        wp_enqueue_script('codemirror_js');
        wp_enqueue_script('codemirror_xml_js');
        wp_enqueue_script('admin_js');
    }

    /**
     * Load language files
     */
    public static function load_textdomain() {
        load_plugin_textdomain(VA_EY4WP_PLUGIN_NAME, false, VA_EY4WP_PLUGIN_NAME . '/lang/');
    }

    /**
     * Initialize
     */
    public function init() {
        $this->add_hooks();
        $this->add_shortcodes();
        $this->register_admin_actions();
        //add scripts and styles
        add_action('admin_enqueue_scripts', array(__CLASS__, 'load_admin_scripts'));
        //add translations
        add_action('init', array(__CLASS__, 'load_textdomain'));
    }

    /**
     * Show result of custom posts actions
     * @global type $post_type
     * @global type $pagenow
     */
    public static function custom_bulk_admin_notices() {
        global $post_type, $pagenow;

        if ($pagenow == 'edit.php' && $post_type == 'post' && filter_input(INPUT_GET, 'eyepin-for-wp-exported') != NULL) {
            $number = filter_input(INPUT_GET, 'eyepin-for-wp-exported');
            if (intval($number) > 0) {
                $message = $number . ' Post(s) zu Eyepin exportiert';
                echo '<div class="notice notice-success is-dismissible"><p>' . esc_html($message) . '</p></div>';
            } else {
                $message = 'Keine Posts zu Eyepin exportiert';
                echo '<div class="notice notice-error is-dismissible"><p>' . esc_html($message) . '</p></div>';
            }
        } else if ($pagenow == 'edit.php' && $post_type == 'post' && filter_input(INPUT_GET, 'eyepin-for-wp-removed') != NULL) {
            $number = filter_input(INPUT_GET, 'eyepin-for-wp-removed');
            if (intval($number) > 0) {
                $message = $number . ' Post(s) von Eyepin gelöscht';
                echo '<div class="notice notice-success is-dismissible"><p>' . esc_html($message) . '</p></div>';
            } else {
                $message = 'Keine Posts von Eyepin gelöscht';
                echo '<div class="notice notice-error is-dismissible"><p>' . esc_html($message) . '</p></div>';
            }
        } else if ($pagenow == 'edit.php' && $post_type == 'post' && filter_input(INPUT_GET, 'eyepin-for-wp-updated') != NULL) {
            $number = filter_input(INPUT_GET, 'eyepin-for-wp-updated');
            if (intval($number) > 0) {
                $message = $number . ' Post(s) bei Eyepin akutalisiert';
                echo '<div class="notice notice-success is-dismissible"><p>' . esc_html($message) . '</p></div>';
            } else {
                $message = 'Keine Posts bei Eyepin akutalisiert';
                echo '<div class="notice notice-error is-dismissible"><p>' . esc_html($message) . '</p></div>';
            }
        }
    }

    /**
     * Add custom column to post table
     * @param array $defaults
     * @return string
     */
    public static function columns_head($defaults) {
        $defaults['eyepin_for_wp'] = 'Eyepin';
        return $defaults;
    }

    /**
     * Show if Post already exported to eyepin
     * @param type $column_name
     * @param type $post_ID
     */
    public static function columns_content($column_name, $post_ID) {
        if ($column_name == 'eyepin_for_wp') {
            if (VA_EY4WP_Utility_Helper::checkPostAlreadyExported($post_ID)) {
                echo '<span class="dashicons dashicons-yes"></span>';
            } else {
                echo '<span class="dashicons dashicons-no"></span>';
            }
        }
    }

    /**
     * Hook to receive posts actions
     * @return type
     */
    public static function custom_bulk_action() {
        $wp_list_table = _get_list_table('WP_Posts_List_Table');
        $action = $wp_list_table->current_action();

        if ($action == 'eyepin-export' || $action == 'eyepin-update' || $action == 'eyepin-remove') {
            $count = 0;
            if (filter_input(INPUT_GET, 'post', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY) != NULL) {
                $post_ids = filter_input(INPUT_GET, 'post', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
            }

            if (empty($post_ids)) {
                //nothing todo
                return;
            }

            $eyepinHelper = new VA_EY4WP_Utility_Eyepinhelper();
        }

        switch ($action) {
            case 'eyepin-export':
                foreach ($post_ids as $post_id) {
                    //check if post not already exported
                    if (!VA_EY4WP_Utility_Helper::checkPostAlreadyExported($post_id)) {
                        if ($eyepinHelper->exportPost($post_id)) {
                            $count++;
                        }
                    }
                }

                // build the redirect url
                $sendback = remove_query_arg(array('eyepin-for-wp-removed', 'eyepin-for-wp-exported', 'eyepin-for-wp-updated'), wp_get_referer());
                $sendback = add_query_arg(array('eyepin-for-wp-exported' => $count), $sendback);
                break;
            case 'eyepin-remove':
                foreach ($post_ids as $post_id) {
                    //check if already on eyepin
                    if (VA_EY4WP_Utility_Helper::checkPostAlreadyExported($post_id)) {
                        if ($eyepinHelper->removePost($post_id)) {
                            $count++;
                        }
                    }
                }

                // build the redirect url
                $sendback = remove_query_arg(array('eyepin-for-wp-removed', 'eyepin-for-wp-exported', 'eyepin-for-wp-updated'), wp_get_referer());
                $sendback = add_query_arg(array('eyepin-for-wp-removed' => $count), $sendback);
                break;
            case 'eyepin-update':
                foreach ($post_ids as $post_id) {
                    //check if already on eyepin
                    if (VA_EY4WP_Utility_Helper::checkPostAlreadyExported($post_id)) {
                        if ($eyepinHelper->updatePost($post_id)) {
                            $count++;
                        }
                    }
                }

                // build the redirect url
                $sendback = remove_query_arg(array('eyepin-for-wp-removed', 'eyepin-for-wp-exported', 'eyepin-for-wp-updated'), wp_get_referer());
                $sendback = add_query_arg(array('eyepin-for-wp-updated' => $count), $sendback);
                break;
            default:
                return;
        }

        // 4. Redirect client
        wp_redirect($sendback);

        exit();
    }

    /**
     * Add Bulk action
     * @global type $post_type
     */
    public static function custom_bulk_admin_footer() {
        global $post_type;

        if ($post_type == 'post') {
            ?>
            <script type="text/javascript">
                jQuery(document).ready(function () {
                    //add
                    jQuery('<option>').val('eyepin-export').text('<?php esc_html_e('Eyepin - exportieren', 'eyepin') ?>').appendTo("select[name='action']");
                    jQuery('<option>').val('eyepin-export').text('<?php esc_html_e('Eyepin - exportieren', 'eyepin') ?>').appendTo("select[name='action2']");

                    //update
                    jQuery('<option>').val('eyepin-update').text('<?php esc_html_e('Eyepin - aktualisieren', 'eyepin') ?>').appendTo("select[name='action']");
                    jQuery('<option>').val('eyepin-update').text('<?php esc_html_e('Eyepin - aktualisieren', 'eyepin') ?>').appendTo("select[name='action2']");

                    //remove
                    jQuery('<option>').val('eyepin-remove').text('<?php esc_html_e('Eyepin - löschen', 'eyepin') ?>').appendTo("select[name='action']");
                    jQuery('<option>').val('eyepin-remove').text('<?php esc_html_e('Eyepin - löschen', 'eyepin') ?>').appendTo("select[name='action2']");
                });
            </script>
            <?php
        }
    }

}
