<?php

/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

defined('ABSPATH') or die('No script kiddies please!');

class VA_EY4WP_Integration {

	/**
	 * 
	 */
	public function add_hooks() {
		if ($this->is_installed()) {
			add_action('wpcf7_init', array($this, 'init'));
			add_action('wpcf7_mail_sent', array($this, 'process'), 1);
		}
	}

	/**
	 * Registers the CF7 shortcode
	 *
	 * @return boolean
	 */
	public function init() {
		wpcf7_add_form_tag('eyepin_for_wp_cf7', array($this, 'shortcode'));
		return true;
	}

	public function is_installed() {
		return function_exists('wpcf7_add_form_tag');
	}

	/**
	 * Return the shortcode output
	 *
	 * @return string
	 */
	public function shortcode($args = array()) {
		$optIn = 'false';
		if (isset($args['options'][0])) {
			if (strpos($args['options'][0], 'true') !== false) {
				$optIn = 'true';
			}
		}
		ob_start();
		echo '<input type="hidden" name="eyepin_for_wp_integration" value="' . esc_attr($optIn) . '">';
		$html = ob_get_clean();
		return $html;
	}

	public function process($cf7_form) {
		$submission = WPCF7_Submission::get_instance();

		if ($submission) {
			$data = $submission->get_posted_data();
		}

		if (isset($data['eyepin_for_wp_integration'])) {
			$eyepinAPIHelper = new VA_EY4WP_Utility_Eyepinhelper();
			$eyepinAPIHelper->submitCF7Address($data);
		}
	}

}
