/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

jQuery(document).ready(() => {
	if (jQuery('#eyepin-for-wp-textarea').length) {
		var editor = wp.CodeMirror((elt) => {
			document.getElementById('eyepin-for-wp-textarea').parentNode.replaceChild(elt, document.getElementById('eyepin-for-wp-textarea'));
		}, {
			value: document.getElementById('eyepin-for-wp-textarea').value,
			mode: "text/html"
		});

		editor.on('change', (cMirror) => {
			document.getElementById('eypepin-for-wp-form-fields-holder').value = cMirror.getValue();

		});
	}

	jQuery('#eyepin-for-wp-tab-fields').on('click', (e) => {
		jQuery('#eyepin-for-wp-tabdiv-fields').show();
		jQuery('#eyepin-for-wp-tabdiv-messages').hide();

		jQuery('#eyepin-for-wp-tab-fields').addClass('nav-tab-active');
		jQuery('#eyepin-for-wp-tab-messages').removeClass('nav-tab-active');

		e.preventDefault();
	});

	jQuery('#eyepin-for-wp-tab-messages').on('click', (e) => {
		jQuery('#eyepin-for-wp-tabdiv-messages').show();
		jQuery('#eyepin-for-wp-tabdiv-fields').hide();

		jQuery('#eyepin-for-wp-tab-fields').removeClass('nav-tab-active');
		jQuery('#eyepin-for-wp-tab-messages').addClass('nav-tab-active');

		e.preventDefault();
	});

	// Google reCaptcha version select

	if(jQuery('input[name="recaptcha-version-select"][value="v2"]').prop('checked') === true) {
		document.getElementById('v2-selected').style.display = 'block';
		document.getElementById('v3-selected').style.display = 'none';
	} else if (jQuery('input[name="recaptcha-version-select"][value="v3"]').prop('checked') === true) {
		document.getElementById('v3-selected').style.display = 'block';
		document.getElementById('v2-selected').style.display = 'none';
	}

	const radioButtons = jQuery('input[name="recaptcha-version-select"]');

	Array.prototype.forEach.call(radioButtons, function(radioButton) {
		radioButton.addEventListener('change', function() {
			// Get the selected value
			const selectedValue = radioButton.value;

			// Hide all content elements
			document.getElementById('v2-selected').style.display = 'none';
			document.getElementById('v3-selected').style.display = 'none';

			// Show the content element corresponding to the selected option
			if (selectedValue === 'v2') {
				document.getElementById('v2-selected').style.display = 'block';
			} else if (selectedValue === 'v3') {
				document.getElementById('v3-selected').style.display = 'block';

				if(document.getElementById('recaptcha-v3-score').value.length === 0) {
					document.getElementById('recaptcha-v3-score').value = '0.5';
				}
			}
		});
	});

	jQuery('#recaptcha-v3-score').on('input', (e) => {
		let value = parseFloat(jQuery('#recaptcha-v3-score').val());

		if (value < 0) {
			jQuery('#recaptcha-v3-score').val(0);
		} else if (value > 1) {
			jQuery('#recaptcha-v3-score').val(1);
		}
	});

	// check if Display as Checkbox recaptcha-v2-display-checkbox is checked and v2 is selected
	jQuery('#reCaptcha-update').on('click', (e) => {
		e.preventDefault();

		let isDisplayCheckbox = jQuery('input[name="recaptcha-v2-display-checkbox"]').prop('checked') === true;
		let isV3 = jQuery('input[name="recaptcha-version-select"][value="v3"]').prop('checked') === true

		if(isDisplayCheckbox && !isV3) {

			if(editor.getDoc().getValue().match(/<input type="hidden" id="g-recaptcha-response"[^>]*><div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/g)) {
				let text = editor.getDoc().getValue().replace(/<div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/, '');

				// remove reCaptcha
				editor.getDoc().setValue(text);
			}

			if(editor.getDoc().getValue().match(/<input type="hidden" id="g-recaptcha-response"[^>]*><input type="hidden" name="action"[^>]*value="validate_captcha">/)) {
				let text = editor.getDoc().getValue().replace(/<input type="hidden" id="g-recaptcha-response"[^>]*><input type="hidden" name="action"[^>]*value="validate_captcha">/, '');

				// remove reCaptcha
				editor.getDoc().setValue(text);
			}

			let $site_keyInput = jQuery('#captcha-sitekey').val();
			let $reCaptchaHtmlElement = '<div class="g-recaptcha" data-sitekey="' + $site_keyInput + '"></div>';


			if(editor.getDoc().getValue().match(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g)) {
				let text = editor.getDoc().getValue();

				text = text.replace(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g, $reCaptchaHtmlElement);

				//update reCaptcha
				editor.getDoc().setValue(text);

				return;
			} else {
				// insert reCaptcha
				editor.getDoc().setValue(editor.getDoc().getValue() + $reCaptchaHtmlElement);
			}
		} else if (!isDisplayCheckbox && !isV3) {

			if(editor.getDoc().getValue().match(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g)) {
				let text = editor.getDoc().getValue().replace(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g, '');

				// remove reCaptcha
				editor.getDoc().setValue(text);
			}

			if(editor.getDoc().getValue().match(/<input type="hidden" id="g-recaptcha-response"[^>]*><input type="hidden" name="action"[^>]*value="validate_captcha">/)) {
				let text = editor.getDoc().getValue().replace(/<input type="hidden" id="g-recaptcha-response"[^>]*><input type="hidden" name="action"[^>]*value="validate_captcha">/, '');

				// remove reCaptcha
				editor.getDoc().setValue(text);
			}

			let $site_keyInput = jQuery('#captcha-sitekey').val();

			let $reCaptchaHtmlElement = '<div class="g-recaptcha" data-sitekey="' + $site_keyInput + '" data-callback="onSubmit" data-size="invisible"></div>';

			if(editor.getDoc().getValue().match(/<div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/g)) {
				let text = editor.getDoc().getValue();

				text = text.replace(/<input type="hidden" id="g-recaptcha-response"[^>]*><div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/g, $reCaptchaHtmlElement);

				//update reCaptcha
				editor.getDoc().setValue(text);

				return;
			} else {
				// insert reCaptcha
				editor.getDoc().setValue(editor.getDoc().getValue() + $reCaptchaHtmlElement);
			}
		} else if (isV3) {

			if(editor.getDoc().getValue().match(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g)) {
				let text = editor.getDoc().getValue().replace(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g, '');

				// remove reCaptcha
				editor.getDoc().setValue(text);
			}

			if(editor.getDoc().getValue().match(/<div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/g)) {
				let text = editor.getDoc().getValue().replace(/<input type="hidden" id="g-recaptcha-response"[^>]*><div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/g, '');

				// remove reCaptcha
				editor.getDoc().setValue(text);
			}

			let $reCaptchaHtmlElement = '<input type="hidden" id="g-recaptcha-response" name="g-recaptcha-response"><input type="hidden" name="action" value="validate_captcha">';

			if(editor.getDoc().getValue().match(/<input type="hidden" id="g-recaptcha-response"[^>]*><input type="hidden" name="action"[^>]*value="validate_captcha">/)) {
				let text = editor.getDoc().getValue();

				text = text.replace(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g, $reCaptchaHtmlElement);

				//update reCaptcha
				editor.getDoc().setValue(text);

				return;
			} else {
				// insert reCaptcha
				editor.getDoc().setValue(editor.getDoc().getValue() + $reCaptchaHtmlElement);
			}
		}
	});


	jQuery('#reCaptcha-remove').on('click', (e) => {
		e.preventDefault();

		if(editor.getDoc().getValue().match(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g))
		{
			let text = editor.getDoc().getValue();

			text = text.replace(/<div class="g-recaptcha" data-sitekey="[^"]*"><\/div>/g, '');

			// remove reCaptcha v2 Checkbox
			editor.getDoc().setValue(text);

			jQuery('#captcha-sitekey').val('');
			jQuery('#captcha-secretkey').val('');
		}

		if(editor.getDoc().getValue().match(/<div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/)) {
			let text = editor.getDoc().getValue().replace(/<div class="g-recaptcha" data-sitekey="[^"]*" data-callback="onSubmit" data-size="invisible"><\/div>/, '');

			// remove reCaptcha v2 Invisible
			editor.getDoc().setValue(text);

			jQuery('#captcha-sitekey').val('');
			jQuery('#captcha-secretkey').val('');
		}

		if(editor.getDoc().getValue().match(/<input type="hidden" id="g-recaptcha-response"[^>]*><input type="hidden" name="action"[^>]*value="validate_captcha">/)) {
			let text = editor.getDoc().getValue().replace(/<input type="hidden" id="g-recaptcha-response"[^>]*><input type="hidden" name="action"[^>]*value="validate_captcha">/, '');

			// remove reCaptcha v3
			editor.getDoc().setValue(text);

			jQuery('#captcha-sitekey').val('');
			jQuery('#captcha-secretkey').val('');
		}
	});


	for (i = 1; i <= 20; i++) {
		if (jQuery('#eyepin-for-wp-form-tag-add-' + i).length) {
			jQuery('#eyepin-for-wp-form-tag-add-' + i).click(((value) => {
				return function () {
					//get all values from formular
					let className = jQuery('input[name="field-class-' + value + '"]').val();
					let idName = jQuery('input[name="field-id-' + value + '"]').val();
					let label = jQuery('input[name="field-label-' + value + '"]').val();
					let placeholder = jQuery('input[name="field-placeholder-' + value + '"]').val();
					let type = jQuery('input[name="field-type-' + value + '"]').val();
					let defaultValue = jQuery('input[name="field-default-' + value + '"]').val();
					let attributeValue = jQuery('#attribute-select-value option:selected').val();
					let salutationDefaultValue = jQuery('#salutation-select-default-value option:selected').val();

					let htmlType = 'text';
					if (type === 'email') {
						htmlType = 'email';
					} else if (type === 'internet') {
						htmlType = 'url';
					} else if (type === 'phone') {
						htmlType = 'tel';
					} else if (type === 'mobile') {
						htmlType = 'tel';
					}

					//build text to insert into textarea
					let insertcode = "\n<fieldset>";

					if (label.length >= 1) {
						insertcode += "\n\t<label";
						if (idName.length >= 1) {
							insertcode += " for=\"" + idName + "\"";
						}
						if (jQuery('input[name="field-required-' + value + '"]').is(":checked")) {
							label += " *";
						}
						insertcode += ">" + label + "</label>";
					}

					if (type === 'salutation') {
						insertcode += "\n\t<select name=\"" + type + "\"";
					} else if (type === 'attribute') {
						insertcode += "\n\t<input type=\"text\" name=\"" + attributeValue + "\"";
					} else {
						insertcode += "\n\t<input type=\"" + htmlType + "\" name=\"" + type + "\"";
					}

					if (type !== 'salutation') {
						if (placeholder.length >= 1) {
							insertcode += " placeholder=\"" + placeholder + "\"";
						}
					}

					if (className.length >= 1) {
						insertcode += " class=\"" + className + "\"";
					}

					if (idName.length >= 1) {
						insertcode += " id=\"" + idName + "\"";
					}

					if (type !== 'salutation') {
						if (defaultValue.length >= 1) {
							insertcode += " value=\"" + defaultValue + "\"";
						}
					}


					if (jQuery('input[name="field-required-' + value + '"]').is(":checked")) {
						insertcode += " required";
					}

					insertcode += ">";

					if (type === 'salutation') {
						if (salutationDefaultValue === 'female') {
							insertcode += "\n\t\t<option selected=\"selected\" value=\"female\">Weiblich</option>";
						} else {
							insertcode += "\n\t\t<option value=\"female\">Weiblich</option>";
						}
						if (salutationDefaultValue === 'male') {
							insertcode += "\n\t\t<option selected=\"selected\" value=\"male\">Männlich</option>";
						} else {
							insertcode += "\n\t\t<option value=\"male\">Männlich</option>";
						}
						if (salutationDefaultValue === 'family') {
							insertcode += "\n\t\t<option selected=\"selected\" value=\"family\">Familie</option>";
						} else {
							insertcode += "\n\t\t<option value=\"company\">Firma</option>";
						}

						insertcode += "\n\t</select>";
					}

					insertcode += "\n</fieldset>\n";

					//insert text
					editor.getDoc().setValue(editor.getDoc().getValue() + insertcode);

					//close modal
					self.parent.tb_remove();
				};
			})(i));
		}
	}
});