
const invisibleElement = document.querySelector('[data-size=\"invisible\"]');
const $site_key = site_key_data.siteKey;
if(invisibleElement) {

    document.getElementById('submit-btn').addEventListener('click', function (e) {
        validate(e);
    });

    function onSubmit(token) {
        const tokenResponse = document.getElementById('g-recaptcha-response').value = token;

        const form = document.getElementById('e-shortcode-form');

        const hiddenInputSend = document.createElement('input');
        const hiddenInputRecaptcha = document.createElement('input');
        hiddenInputSend.type = 'hidden';
        hiddenInputSend.name = 'send';
        hiddenInputSend.value = '»';

        hiddenInputRecaptcha.type = 'hidden';
        hiddenInputRecaptcha.name = 'g-recaptcha-response';
        hiddenInputRecaptcha.value = tokenResponse;
        form.appendChild(hiddenInputSend);
        form.appendChild(hiddenInputRecaptcha);

        // Trigger a form submission event to include the hidden field values
        form.dispatchEvent(new Event('submit', { bubbles: true }));

        // Submit the form programmatically
        form.submit();
    }

    function validate(event) {
        event.preventDefault();
        grecaptcha.execute();
    }
}

const reCaptchav3 = document.querySelector('input[name=\"action\"][value=\"validate_captcha\"]');

if(reCaptchav3 && !invisibleElement) {
    document.getElementById('submit-btn').addEventListener('click', function (e) {
        onClick(e);
    });

    function onClick(e) {
        e.preventDefault();
        grecaptcha.ready(function() {
            const form = document.getElementById('e-shortcode-form');

            grecaptcha.execute($site_key, {action:'validate_captcha'})
                .then(function(token) {
                    // add token value to form
                    document.getElementById('g-recaptcha-response').value = token;
                    const hiddenInputSend = document.createElement('input');
                    hiddenInputSend.type = 'hidden';
                    hiddenInputSend.name = 'send';
                    hiddenInputSend.value = '»';
                    form.appendChild(hiddenInputSend);

                    form.dispatchEvent(new Event('submit', { bubbles: true }));
                    form.submit();
                });
        });
    }
}