<?php
/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

class VA_EY4WP_Admin_Form {

	public function display($id = FALSE) {
		$form = VA_EY4WP_Utility_Helper::getFormForId($id);
		if ($form != NULL) {
            $site_key = esc_html($form->site_key);
            $secret_key = esc_html($form->secret_key);
            $secret_key = esc_html($form->secret_key);
            $score = esc_html($form->score);
            $re_captcha_version_type = esc_html($form->re_captcha_version_type);
            $v2CheckboxIsChecked = esc_html($form->v2_checkbox_is_checked);
            $textareaValue = esc_html($form->form);

			$name = esc_html($form->name);
			$messageSent = esc_html($form->message_sent);
			$messageNotSent = esc_html($form->message_not_sent);
			$messageFieldError = esc_html($form->message_field_error);
            $messageFieldAlreadyExists = esc_html($form->message_field_already_exists);
            $messageRecaptchaNotCorrect = esc_html($form->message_recaptcha_incorrect);
			$optIn = esc_html($form->opt_in);
		} else {
			//set default values
            $site_key = '';
            $re_captcha_version_type = 'v2';
            $score = ($re_captcha_version_type == 'v2') ? null : 0.5;
			$textareaValue = '<fieldset>
	<label>Anrede</label>
	<select name="salutation" required>
		<option value="female">Frau</option>
		<option selected="selected" value="male">Herr</option>
		<option value="family">Familie</option>
	</select>
</fieldset>

<fieldset>
	<label>Vorname</label>
	<input type="text" name="firstname" placeholder="Vorname *" required>
</fieldset>

<fieldset>
	<label>Nachname</label>
	<input type="text" name="lastname" placeholder="Nachname *" required>
</fieldset>

<fieldset>
	<label>E-Mail Adresse</label>
	<input type="email" name="email" placeholder="E-Mail Adresse *" required>
</fieldset>
';
			$name = "Kontaktformular";
			$messageSent = "Ihre Anmeldung war erfolgreich.";
			$messageNotSent = "Ihre Anmeldung war nicht erfolgreich. Bitte kontaktieren Sie uns.";
			$messageFieldError = "Pflichtfelder dürfen nicht leer sein.";
            $messageFieldAlreadyExists = "Ihre Anmeldung war erfolgreich.";
            $messageRecaptchaNotCorrect = "Ihre Anmeldung war nicht erfolgreich. Bitte kontaktieren Sie uns.";
			$optIn = "Ja";
			$v2CheckboxIsChecked = "Ja";
		}
		?>
		<div class="wrap">
			<h1 class="page-title">
				<?php esc_html_e('eyepin', 'eyepin'); ?> ›
                <?php if ($form == NULL){
                    esc_html_e('Neues Formular hinzufügen', 'eyepin');
				} else {
                    esc_html_e('Formular bearbeiten', 'eyepin');
				} ?>
			</h1>
			<form method="post" action="<?php echo esc_url(site_url()); ?>/wp-admin/admin.php?page=eyepin-for-wp-forms" id="va-ey4wp-admin-form">
				<?php
				wp_nonce_field('eyepin-for-wp-form-form');
				if ($form != NULL) {
					echo '<input type="hidden" name="wordpress-for-eypin-form-id" value="' . esc_attr($form->id) . '">';
				}
				?>
				<div id="poststuff">
					<div id="post-body" class="metabox-holder columns-2">
						<div id="post-body-content">
							<div id="titlediv">
								<div id="titlewrap">
									<label class="screen-reader-text" id="title-prompt-text" for="title"><?php esc_html_e('Titel hier eingeben', 'eyepin') ?></label>
									<input type="text" name="form_name" value="<?php echo esc_attr($name); ?>" size="30" id="title" spellcheck="true" autocomplete="off">
								</div>
							</div>
						</div>

						<div id="postbox-container-1" class="postbox-container">
							<div id="submitdiv" class="postbox">
								<h3><?php esc_html_e('Funktionen', 'eyepin') ?> </h3>
								<div class="inside">
									<div class="submitbox" id="submitpost">
										<div id="minor-publishing-actions">
											<input type="submit" class="button-primary" name="wpcf7-save" value="Speichern">
										</div>
										<div id="misc-publishing-actions">
										</div>
									</div>

								</div>
							</div>
							<div id="settingsdiv" class="postbox">
								<h3><?php esc_html_e('E-Mail versenden:', 'eyepin') ?></h3>
								<div class="inside">
									<p><?php esc_html_e('Opt-in E-Mail über eyepin versenden', 'eyepin') ?>:</p>
									<select id="eyepin-for-wp-optin-eyepin-mail" name="form-optin-eyepin">
										<option value="Ja" <?php if($optIn == 'Ja') { echo 'selected="selected"';} ?>><?php esc_html_e('Ja', 'eyepin') ?></option>
										<option value="Nein" <?php if($optIn == 'Nein') { echo 'selected="selected"';} ?>><?php esc_html_e('Nein', 'eyepin') ?></option>
									</select>
								</div>
							</div>
                            <!-- Google reCaptcha -->
                            <div id="captcha" class="postbox" style="display: flex; justify-content: center; align-items: start; flex-direction: column">
                                <h3><?php esc_html_e('Google Recaptcha', 'eyepin') ?></h3>
                                <div class="inside">
                                    <div style="margin-bottom: 0.5em;">
                                        <label for="captcha-sitekey">Site key</label>
                                        <input type="text"  name="recaptcha-sitekey" id="captcha-sitekey" style="width: 100%" value="<?php if(!empty($site_key)) { echo esc_html($site_key);} ?>">
                                    </div>
                                    <div style="margin-bottom: 1em">
                                        <label for="captcha-secretkey">Secret key</label>
                                        <input type="text" name="recaptcha-secretkey" id="captcha-secretkey" style="width: 100%" value="<?php if(!empty($secret_key)) { echo esc_html($secret_key);} ?>">
                                    </div>
                                    <div style="margin-bottom: 1em">
                                        <h4><?php esc_html_e('Version', 'eyepin') ?></h4>
                                        <input type="radio" name="recaptcha-version-select" id="recaptcha-version-select-v2" value="v2" <?php if(!empty($re_captcha_version_type) && $re_captcha_version_type === 'v2') { echo 'checked';} ?>>
                                        <label for="recaptcha-version-select">V2</label><br>
                                        <input type="radio" name="recaptcha-version-select" id="recaptcha-version-select-v3" value="v3" <?php if(!empty($re_captcha_version_type) && $re_captcha_version_type === 'v3') { echo 'checked';} ?>>
                                        <label for="recaptcha-version-select">V3</label>
                                    </div>
                                    <!-- Display for Google reCaptcha v2-->
                                    <div id="v2-selected" style="margin-bottom: 1em;">
                                        <h4><?php esc_html_e('Display as Checkbox', 'eyepin') ?></h4>
                                        <input type="checkbox" name="recaptcha-v2-display-checkbox" id="recaptcha-v2-display-checkbox" value="Ja" <?php if(!empty($v2CheckboxIsChecked) && $v2CheckboxIsChecked === 'Ja') { echo 'checked';} ?>
                                        <label for="recaptcha-v2-display-checkbox">Yes</label>
                                    </div>
                                    <!-- Display for Google reCaptcha v3-->
                                    <div id="v3-selected" style="margin-bottom: 1em;">
                                        <h4><?php esc_html_e('Score', 'eyepin') ?></h4>
                                        <p><small>(Der Score-Wert sollte zwischen 0,0 und 1 liegen)</small></p>
                                        <input type="number" min="0.0" max="1.0" step="0.1" name="recaptcha-v3-score" style="width: 50%" id="recaptcha-v3-score" value="<?php if(!empty($score)) { echo esc_html($score);} ?>">
                                    </div>
                                    <div style="margin-bottom: 1em">
                                        <input type="submit" class="button-primary" id="reCaptcha-update" value="Aktualisieren">
                                        <input type="submit" class="button-primary" id="reCaptcha-remove" value="Entfernen">
                                    </div>
                                </div>
                            </div>
							<div id="infodiv" class="postbox">
								<h3><?php esc_html_e('Informationen', 'eyepin') ?></h3>
								<div class="inside">
									<ul>
										<li><a target="_blank" href="http://www.eyepin.com/"><?php esc_html_e('Eyepin', 'eyepin') ?></a></li>
										<li><a target="_blank" href="http://www.eyepin.com/de/kontakt/?no_cache=1/"><?php esc_html_e('Kontakt', 'eyepin') ?></a></li>
									</ul>
								</div>
							</div>
						</div>

						<div id="postbox-container-2" class="postbox-container">
							<div id="contact-form-editor" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
								<h2 class="nav-tab-wrapper wp-clearfix eyepin-for-pw-tab-header">
									<a id="eyepin-for-wp-tab-fields" href="#" class="nav-tab nav-tab-active"><?php esc_html_e('Felder', 'eyepin') ?></a>
									<a id="eyepin-for-wp-tab-messages" href="#" class="nav-tab"><?php esc_html_e('Nachrichten', 'eyepin') ?></a>
								</h2>
								<div class="eyepin-for-wp-fields" id="eyepin-for-wp-tabdiv-fields">
		<?php include(VA_EY4WP_PLUGIN_DIR . 'admin/pages/tabs/form-fields.php'); ?>
								</div>
								<div class="eyepin-for-wp-fields hidden" id="eyepin-for-wp-tabdiv-messages">
		<?php include(VA_EY4WP_PLUGIN_DIR . 'admin/pages/tabs/form-messages.php'); ?>
								</div>
							</div>
						</div>
					</div>
					<br class="clear">
				</div>
			</form>
		</div>
		<?php
	}

}
