<?php
/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

defined('ABSPATH') or die('No script kiddies please!');

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class VA_EY4WP_Admin_Pages extends WP_List_Table {

    const TABLE_NAME = 'va_ey4wp_settings';

    static function show_settings_form($message = '', $class = '', $message_client = '', $class_client = '', $message_overwriteAddress = '', $class_overwriteAddress = '') {
        $pwd = get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', '');
        if (strlen($pwd) != 0) {
            $pwd = '******';
        }
        $eyepinHelper = new VA_EY4WP_Utility_Eyepinhelper();
        $clients = $eyepinHelper->loadAccounts();
        ?>
        <div class="wrap">
            <h1 class="page-title"><?php esc_html_e('eyepin', 'eyepin') ?> › <?php esc_html_e('Einstellungen', 'eyepin') ?></h1>
            <h2><?php esc_html_e('Schnittstellen-Daten', 'eyepin') ?></h2>
            <form method="post" action="<?php echo esc_url(menu_page_url(VA_EY4WP_PLUGIN_NAME, false)); ?>">
                <input name='<?php echo esc_attr(VA_EY4WP_PLUGIN_NAME); ?>-action' type="hidden" value="<?php echo esc_attr(VA_EY4WP_PLUGIN_NAME); ?>-settings-form-submit"/>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row">
                            <label for="eyepin_username">Eyepin - API <?php esc_html_e('Benutzername', 'eyepin') ?> *</label>
                        </th>
                        <td>
                            <input required name="eyepin_username" type="text" value="<?php echo esc_attr(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', '')); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="eyepin_password">Eyepin - API <?php esc_html_e('Passwort', 'eyepin') ?> *</label>
                        </th>
                        <td>
                            <input required name="eyepin_password" type="password" value="<?php echo esc_attr($pwd); ?>" class="regular-text">
                        </td>
                    </tr>
                    </tbody>
                </table>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_html_e('Änderungen übernehmen', 'eyepin') ?>">
                </p>
                <?php
                if (strlen(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', '')) != 0) {
                    if ($clients[0] == '-1') {
                        echo '<div class="message-error">' . esc_html__('Zugangsdaten nicht korrekt!', 'eyepin') . '</div>';
                    }
                }
                ?>
            </form>
            <?php
            if (isset($message) && isset($class)) {
                echo '<div class="message-' . esc_attr($class) . '">' . esc_html($message) . '</div>';
            }
            ?>

            <h2>Adressmanagement</h2>
            <?php

//            global $wpdb;
//            $overwriteAddress = 0;
//            $sql = "SELECT * FROM {$wpdb->prefix}" . self::TABLE_NAME;
//            $result = $wpdb->get_results($sql, 'ARRAY_A');
//            if ($result){
//                foreach ($result as $k => $v){
//                    if ($v["name"] == "overwrite_address"){
//                        $overwriteAddress = $v["value"];
//                    }
//                }
//            }

            global $wpdb;
            $overwriteAddress = 0;
            $table_name = "{$wpdb->prefix}va_ey4wp_settings";

            $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM %i", $table_name), 'ARRAY_A'); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
            if ($result){
                foreach ($result as $k => $v){
                    if ($v["name"] == "overwrite_address"){
                        $overwriteAddress = $v["value"];
                    }
                }
            }

            ?>

            <form method="post" action="<?php echo esc_url(menu_page_url(VA_EY4WP_PLUGIN_NAME, false)); ?>">
                <input name='<?php echo esc_attr(VA_EY4WP_PLUGIN_NAME); ?>-action' type="hidden" value="<?php echo esc_attr(VA_EY4WP_PLUGIN_NAME); ?>-settings-overwriteaddress-form-submit"/>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row">
                            <label for="overwrite-contact">Sollen bestehende Kontakte bei erneuter Anmeldung aktualisiert werden?</label>

                        </th>
                        <td>
                            <select id="overwrite-contact" name="eyepin_addressoverwrite">
                                <option value="0" <?php if ($overwriteAddress == '0') echo "selected"; ?>>Nein</option>
                                <option value="1" <?php if ($overwriteAddress == '1') echo "selected"; ?>>Ja</option>
                            </select>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_html_e('Änderungen übernehmen', 'eyepin') ?>">
                </p>
            </form>

            <?php
            if (isset($message_overwriteAddress) && isset($class_overwriteAddress)) {
                echo '<div class="message-' . esc_attr($class_overwriteAddress) . '">' . esc_html($message_overwriteAddress) . '</div>';
            }
            ?>

            <h2>Mandanten</h2>
            <form method="post" action="<?php echo esc_url(menu_page_url(VA_EY4WP_PLUGIN_NAME, false)); ?>">
                <input name='<?php echo esc_attr(VA_EY4WP_PLUGIN_NAME); ?>-action' type="hidden" value="<?php echo esc_attr(VA_EY4WP_PLUGIN_NAME); ?>-settings-client-form-submit"/>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row">
                            <label for="eyepin_username">Eyepin - <?php esc_html_e('Mandant', 'eyepin') ?> *</label>
                        </th>
                        <td>
                            <select id="eyepin_client" name="eyepin_client">
                                <?php

                                if(!is_array($clients) || empty($clients)) {
                                    $clients = [];
                                }

                                if (strlen(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_client') == 0 &&
                                    isset($clients[0]['id']) &&
                                    $clients[0]['id'] != -1)
                                ) {
                                    echo '<option value="0">-</option>';
                                }

                                if(is_array($clients)) {
                                    foreach ($clients as $client) {
                                        if ($client == '-' || $client == '-1') {
                                            echo '<option value="0">-</option>';
                                        } else {
                                            if ($client['id'] == get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_client', '')) {
                                                echo '<option selected="selected" value="' . esc_attr($client['id']) . '">' . esc_html($client['name']) . '</option>';
                                            } else {
                                                echo '<option value="' . esc_attr($client['id']) . '">' . esc_html($client['name']) . '</option>';
                                            }
                                        }
                                    }
                                } else {
                                    echo '<option value="0">-</option>';
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_html_e('Änderungen übernehmen', 'eyepin') ?>">
                </p>
            </form>

            <?php
            if (isset($message_client) && isset($class_client)) {
                echo '<div class="message-' . esc_attr($class_client) . '">' . esc_html($message_client) . '</div>';
            }
            ?>

        </div>

        <?php
    }

}
