<?php
/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */
?>

<h2><?php esc_html_e('Formularfelder', 'eyepin')?></h2>
<span id="tag-generator-list">
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-email" class="thickbox button" title="Eyepin - Formularfeld - E-Mail">E-Mail</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-salutation" class="thickbox button" title="Formular-Tag Generator: Anrede">Anrede</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-title" class="thickbox button" title="Formular-Tag Generator: Titel">Titel</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-firstname" class="thickbox button" title="Formular-Tag Generator: Vorname">Vorname</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-lastname" class="thickbox button" title="Formular-Tag Generator: Nachname">Nachname</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-street" class="thickbox button" title="Formular-Tag Generator: Straße">Straße</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-zip" class="thickbox button" title="Formular-Tag Generator: PLZ">PLZ</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-city" class="thickbox button" title="Formular-Tag Generator: Stadt">Stadt</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-country" class="thickbox button" title="Formular-Tag Generator: Land">Land</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-phone" class="thickbox button" title="Formular-Tag Generator: Telefon">Telefon</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-fax" class="thickbox button" title="Formular-Tag Generator: Fax">Fax</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-mobile" class="thickbox button" title="Formular-Tag Generator: Mobil">Mobil</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-internet" class="thickbox button" title="Formular-Tag Generator: Internet">Internet</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-company" class="thickbox button" title="Formular-Tag Generator: Firma">Firma</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-function" class="thickbox button" title="Formular-Tag Generator: Funktion">Funktion</a>
	<a href="#TB_inline?width=900&amp;height=290&amp;inlineId=generate-attribute" class="thickbox button" title="Formular-Tag Generator: Benutzerdefiniert">Benutzerdefiniert</a>
</span>
<textarea id="eyepin-for-wp-textarea" name="eyepin-for-wp-text" cols="100" rows="25"><?php echo esc_html($textareaValue); ?></textarea>
<textarea class="hidden" id="eypepin-for-wp-form-fields-holder" name="eypepin-for-wp-form-fields" cols="1" rows="1"><?php echo esc_html($textareaValue); ?></textarea>

<?php
add_thickbox();
$buttons = array('email', 'title', 'firstname', 'lastname', 'street', 'zip', 'city', 'country', 'phone', 'fax', 'mobile', 'internet', 'company', 'function');
$id = 1;
foreach ($buttons as $button) {
	$divId = 'generate-' . $button;
	?>
	<div id="<?php echo esc_html($divId); ?>" class="hidden">
		<table class="eyepin-for-wp-field-table">
			<tr>
				<th><label><?php esc_html_e('Bezeichnung', 'eyepin') ?>:</label></th>
				<td>
					<input type="hidden" name="field-type-<?php echo esc_attr($id); ?>" value="<?php echo esc_attr($button); ?>">
					<input type="text" name="field-label-<?php echo esc_attr($id); ?>" value="">
				</td>
			</tr>
			<tr>
				<th><label><?php esc_html_e('erforderlich', 'eyepin') ?>:</label></th>
				<td><input type="checkbox" name="field-required-<?php echo esc_attr($id); ?>" value="on"> <?php esc_html_e('Dieses Feld ist erforderlich', 'eyepin') ?></td>
			</tr>
			<tr>
				<th><label><?php esc_html_e('Platzhalter', 'eyepin') ?>:</label></th>
				<td><input type="text" name="field-placeholder-<?php echo esc_attr($id); ?>" value=""></td>
			</tr>
			<tr>
				<th><label><?php esc_html_e('Standardwert', 'eyepin') ?>:</label></th>
				<td><input type="text" name="field-default-<?php echo esc_attr($id); ?>" value=""> </td>
			</tr>
			<tr>
				<th><label><?php esc_html_e('CSS ID', 'eyepin') ?>:</label></th>
				<td><input type="text" name="field-id-<?php echo esc_attr($id); ?>" value=""></td>
			</tr>
			<tr>
				<th><label><?php esc_html_e('CSS Klasse', 'eyepin') ?>:</label></th>
				<td><input type="text" name="field-class-<?php echo esc_attr($id); ?>" value=""></td>
			</tr>
		</table>
		<input id="eyepin-for-wp-form-tag-add-<?php echo esc_attr($id); ?>"  type="button" class="button button-primary insert-tag" value="Tag einfügen">
		<div class="eyepin-for-wp-field-error hidden"><?php esc_html_e('Geben Sie alle nötigen Daten ein!', 'eyepin') ?></div>
	</div>
	<?php
	$id++;
}
?>

<div id="generate-attribute" class="hidden">
	<table class="eyepin-for-wp-field-table-16">
		<tr>
			<th><label>Typ:</label></th>
			<td>
				<select id="attribute-select-value" class="attribute-select" name="field-attribute-select">
					<option value="attribute1">Attribut 1</option>
					<option value="attribute2">Attribut 2</option>
					<option value="attribute3">Attribut 3</option>
					<option value="attribute4">Attribut 4</option>
					<option value="attribute5">Attribut 5</option>
					<option value="attribute6">Attribut 6</option>
					<option value="attribute7">Attribut 7</option>
					<option value="attribute8">Attribut 8</option>
					<option value="attribute9">Attribut 9</option>
					<option value="attribute10">Attribut 10</option>
					<option value="attribute11">Attribut 11</option>
					<option value="attribute12">Attribut 12</option>
					<option value="attribute13">Attribut 13</option>
					<option value="attribute14">Attribut 14</option>
					<option value="attribute15">Attribut 15</option>
					<option value="attribute16">Attribut 16</option>
					<option value="attribute17">Attribut 17</option>
					<option value="attribute18">Attribut 18</option>
					<option value="attribute19">Attribut 19</option>
					<option value="attribute20">Attribut 20</option>
				</select>
			</td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('Bezeichnung', 'eyepin') ?>:</label></th>
			<td>
				<input type="hidden" name="field-type-16" value="attribute">
				<input type="text" name="field-label-16" value="">
			</td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('erforderlich', 'eyepin') ?>:</label></th>
			<td><input type="checkbox" name="field-required-16" value="on"> <?php esc_html_e('Dieses Feld ist erforderlich', 'eyepin') ?></td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('Platzhalter', 'eyepin') ?>:</label></th>
			<td><input type="text" name="field-placeholder-16" value=""></td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('Standardwert', 'eyepin') ?>:</label></th>
			<td><input type="text" name="field-default-16" value=""> </td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('CSS ID', 'eyepin') ?>:</label></th>
			<td><input type="text" name="field-id-16" value=""></td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('CSS Klasse', 'eyepin') ?>:</label></th>
			<td><input type="text" name="field-class-16" value=""></td>
		</tr>
	</table>
	<input id="eyepin-for-wp-form-tag-add-16"  type="button" class="button button-primary insert-tag" value="Tag einfügen">
	<div class="eyepin-for-wp-field-error hidden"><?php esc_html_e('Geben Sie alle nötigen Daten ein!', 'eyepin') ?></div>
</div>

<div id="generate-salutation" class="hidden">
	<table class="eyepin-for-wp-field-table-17">
		<tr>
			<th><label><?php esc_html_e('Standardwert', 'eyepin') ?>:</label></th>
			<td>
				<select id="salutation-select-default-value" class="attribute-select" name="field-salutation-default-select">
					<option value="female">Frau</option>
					<option value="male">Herr</option>
					<option value="family">Familie</option>
				</select>
			</td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('Bezeichnung', 'eyepin') ?>:</label></th>
			<td>
				<input type="hidden" name="field-type-17" value="salutation">
				<input type="text" name="field-label-17" value="">
			</td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('erforderlich', 'eyepin') ?>:</label></th>
			<td><input type="checkbox" name="field-required-17" value="on"> <?php esc_html_e('Dieses Feld ist erforderlich', 'eyepin') ?></td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('CSS ID', 'eyepin') ?>:</label></th>
			<td><input type="text" name="field-id-17" value=""></td>
		</tr>
		<tr>
			<th><label><?php esc_html_e('CSS Klasse', 'eyepin') ?>:</label></th>
			<td><input type="text" name="field-class-17" value=""></td>
		</tr>
	</table>
	<input id="eyepin-for-wp-form-tag-add-17"  type="button" class="button button-primary insert-tag" value="Tag einfügen">
	<div class="eyepin-for-wp-field-error hidden"><?php esc_html_e('Geben Sie alle nötigen Daten ein!', 'eyepin') ?></div>
</div>