<?php

/**
 * Plugin Name: eyepin
 * Plugin URI: https://www.eyepin.com
 * Description: This Plugin adds Eyepin Support to WordPress.
 * Version: 2.0.0
 * Author: varioous
 * Author URI: https://chilischarf.at
 * Text Domain: eyepin
 * License: GPL2
 * 
 * eyepin
 * Copyright (C) 2016, chilischarf.at
 */
class VA_EY4WP_Dashboard {

	protected static $_instance = NULL;

	function __construct() {
		require_once __DIR__ . '/utility/class-autoloader.php';
		VA_EY4WP_Autoloader::register();
	}

	/**
	 * Create an unique instance throught the app 
	 */
	public static function instance() {
		return self::$_instance = self::$_instance ? : new self();
	}

	/**
	 * Create tables when installing plugin
	 */
	public static function install() {
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		$table_name = $wpdb->prefix . VA_EY4WP_Admin_Forms::TABLE_NAME;
		$table_name_exported = $wpdb->prefix . VA_EY4WP_Admin_Forms::TABLE_NAME_EXPORTED;
		$table_name_settings = $wpdb->prefix . VA_EY4WP_Admin_Pages::TABLE_NAME;

		$sql = "CREATE TABLE $table_name (
		id mediumint(9) NOT NULL AUTO_INCREMENT,
		name varchar(200),
		message_sent text,
		message_not_sent text,
		message_field_error text,
		message_field_already_exists text,
		message_recaptcha_incorrect text,
		form text,
		opt_in varchar(10),
		site_key varchar(255),
		secret_key varchar(255),
		re_captcha_version_type varchar(255),
		v2_checkbox_is_checked varchar(10),
		score DECIMAL(1,1),
		UNIQUE KEY id (id)
	) $charset_collate;";
		
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta($sql);

		$sqlExportedTable = "CREATE TABLE $table_name_exported (
		id mediumint(9) NOT NULL AUTO_INCREMENT,
		post_id bigint(20) NOT NULL,
		eyepin_id bigint(20) NOT NULL,
		UNIQUE KEY id (id)
	) $charset_collate;";

		dbDelta($sqlExportedTable);


		$sqlSettingsTable = "CREATE TABLE $table_name_settings (
		name varchar(200),
		value varchar(200),
		PRIMARY KEY (name),
		UNIQUE KEY name (name)
	) $charset_collate;";

        dbDelta($sqlSettingsTable);


	}


	/**
	 * Start to setup hook
	 */
	public function run() {
		define('VA_EY4WP_PLUGIN_NAME', 'eyepin-for-wp');
		define('VA_EY4WP_PLUGIN_VERSION', '2.0.0');
		define('VA_EY4WP_PLUGIN_DIR', dirname(__FILE__) . '/');
		define('VA_EY4WP_PLUGIN_URL', plugins_url('/', __FILE__));
		define('VA_EY4WP_PLUGIN_FILE', __FILE__);

		register_activation_hook(__FILE__, array(__CLASS__, 'install'));

		$adminPanel = new VA_EY4WP_Admin();
		$adminPanel->init();
	}

}

VA_EY4WP_Dashboard::instance()->run();
