<?php

/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

defined('ABSPATH') or die('No script kiddies please!');

if (!defined('WP_UNINSTALL_PLUGIN')) {
	exit();
}

/**
 * Remove tables and options from plugin
 * @global type $wpdb
 */
function eyepin_for_wp_delete_plugin() {
    global $wpdb;
    delete_option('eyepin-for-wp_eyepin_client');
    delete_option('eyepin-for-wp_eyepin_password');
    delete_option('eyepin-for-wp_eyepin_username');

    $table_name = "{$wpdb->prefix}va_ey4wp_forms";
    $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %i", $table_name)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery

    $table_name_exported = "{$wpdb->prefix}va_ey4wp_eyepin_exported";
    $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %i", $table_name_exported)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery

    $table_name_settings = "{$wpdb->prefix}va_ey4wp_settings";
    $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %i", $table_name_settings)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
}

eyepin_for_wp_delete_plugin();
?>