<?php

/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

defined('ABSPATH') or die('No script kiddies please!');

class VA_EY4WP_Autoloader {

	/**
	 * Registers VA_EY4WP_Autoloader as an SPL autoloader.
	 *
	 * @param boolean $prepend
	 */
	public static function register($prepend = false) {
		if (version_compare(phpversion(), '5.3.0', '>=')) {
			spl_autoload_register(array(new self, 'autoload'), true, $prepend);
		} else {
			spl_autoload_register(array(new self, 'autoload'));
		}
	}

	/**
	 * Handles autoloading of VA_EY4WP classes.
	 *
	 * @param string $class
	 */
	public static function autoload($class) {
		if (0 !== strpos($class, 'VA_EY4WP')) {
			return;
		}

		$file = dirname(__FILE__) . '/class-' . strtolower(str_replace(array('_', "\0"), array('-', ''), str_replace("VA_EY4WP_", "", $class)) . '.php');

		if (is_file($file)) {
			require_once $file;
		} else if (is_file($fileRequire = str_replace('utility', 'admin', $file))) {
			require_once $fileRequire;
		} else if (is_file($fileRequire = str_replace('utility', 'api', $file))) {
			require_once $fileRequire;
		} else if (is_file($fileRequire = str_replace('utility', 'admin/pages', $file))) {
			require_once $fileRequire;
		}
	}

}
