<?php


/* * **************************************************************************************

 *

 *  Copyright notice

 *

 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG

 *

 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation, either version 2 of the License, or

 *  any later version.

 *

 *  Eyepin For Wordpress is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.

 *

 *  This copyright notice MUST APPEAR in all copies of the script!

 * ************************************************************************************** */


defined('ABSPATH') or die('No script kiddies please!');


class VA_EY4WP_Utility_Eyepinhelper
{


    const EYEPIN_HOST = 'https://apiv3.eyepin.com/interface3.php';


    /**
     * Export post to eyepin
     * @param type $post_id
     * @return boolean
     */

    public function exportPost($post_id)
    {

        $eyepinConnection = new VA_EY4WP_Api_Eyepin();

        $eyepinConnection->setHost(self::EYEPIN_HOST);

        $eyepinConnection->setUsername(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', ''));

        $eyepinConnection->setPassword(VA_EY4WP_Utility_Helper::decrypt(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', ''), AUTH_KEY));

        $post = get_post($post_id);

        $langCode = 'de';
        $postLanguageDetails = apply_filters('wpml_post_language_details', NULL, $post_id);
        if (is_array($postLanguageDetails) && !is_null($postLanguageDetails['language_code'])){
            $langCode = $postLanguageDetails['language_code'];
        }




        $postImageUrl = '';


        if (has_post_thumbnail($post->ID)) {

            $postImageUrl = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail')[0];

        }


        $contentArr = get_extended($post->post_content);


        $data = array(

            'title' => utf8_encode(get_the_title($post)),

            'opener' => utf8_encode(apply_filters('the_content', get_extended($post->post_content)['main'])),

            'detail' => utf8_encode($contentArr['extended']),

            'detailurl' => esc_url(get_permalink($post)),

            'pictureurl' => esc_url($postImageUrl),

            'lang' => $langCode,

        );


        //send post to eyepin

        $connectionResult = $eyepinConnection->sendCommand('ContentInsert', $data);

        if ($connectionResult == EYEPIN_CON_SUCCESS) {

            $response = $eyepinConnection->getResponse();

            $eyepinId = intval($response->data[0]);


            //store exported post into table

            global $wpdb;

            $tableName = $wpdb->prefix . VA_EY4WP_Admin_Forms::TABLE_NAME_EXPORTED;


            $tableData = array(

                'post_id' => $post_id,

                'eyepin_id' => $eyepinId

            );


            $wpdb->insert($tableName, $tableData); // phpcs:ignore WordPress.DB.DirectDatabaseQuery

            return true;

        }

        return false;

    }


    /**
     * Update post on eyepin
     * @param type $post_id
     * @return boolean
     */

    public function updatePost($post_id)
    {

        $eyepinConnection = new VA_EY4WP_Api_Eyepin();

        $eyepinConnection->setHost(self::EYEPIN_HOST);

        $eyepinConnection->setUsername(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', ''));

        $eyepinConnection->setPassword(VA_EY4WP_Utility_Helper::decrypt(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', ''), AUTH_KEY));

        $post = get_post($post_id);


        $langCode = substr(get_locale(),0,2);

        $postLanguageDetails = apply_filters('wpml_post_language_details', NULL, $post_id);
        if (is_array($postLanguageDetails) && !is_null($postLanguageDetails['language_code'])){
            $langCode = $postLanguageDetails['language_code'];
        }

        $postImageUrl = '';


        if (has_post_thumbnail($post->ID)) {

            $postImageUrl = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail')[0];

        }


        $contentArr = get_extended($post->post_content);


        $data = array(

            'eyepin_id' => VA_EY4WP_Utility_Helper::getEyepinIdForPostId($post_id),

            'title' => utf8_encode(get_the_title($post)),

            'opener' => utf8_encode(apply_filters('the_content', get_extended($post->post_content)['main'])),

            'detail' => utf8_encode($contentArr['extended']),

            'detailurl' => esc_url(get_permalink($post)),

            'pictureurl' => esc_url($postImageUrl),

            'lang' => $langCode

        );


        //send post to eyepin

        $connectionResult = $eyepinConnection->sendCommand('ContentUpdate', $data);

        if ($connectionResult == EYEPIN_CON_SUCCESS) {

            return true;

        }

        return false;

    }


    /**
     * Remove post from eyepin
     * @param type $post_id
     * @return boolean
     */

    public function removePost($post_id)
    {

        $eyepinConnection = new VA_EY4WP_Api_Eyepin();

        $eyepinConnection->setHost(self::EYEPIN_HOST);

        $eyepinConnection->setUsername(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', ''));

        $eyepinConnection->setPassword(VA_EY4WP_Utility_Helper::decrypt(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', ''), AUTH_KEY));


        $data = array(

            'id' => VA_EY4WP_Utility_Helper::getEyepinIdForPostId($post_id)

        );


        //send post to eyepin

        $connectionResult = $eyepinConnection->sendCommand('ContentDelete', $data);

        if ($connectionResult == EYEPIN_CON_SUCCESS) {

            //remove post from table

            global $wpdb;

            $tableName = $wpdb->prefix . VA_EY4WP_Admin_Forms::TABLE_NAME_EXPORTED;

            $wpdb->delete($tableName, array('post_id' => $post_id), array('%d')); // phpcs:ignore WordPress.DB.DirectDatabaseQuery

            return true;

        }

        return false;

    }


    /**
     * Send submit to eyepin
     * @global type $wpdb
     * @param type $values
     * @return boolean
     */

    public function submitAddress($values, $form)
    {

        $eyepinConnection = new VA_EY4WP_Api_Eyepin();

        $eyepinConnection->setHost(self::EYEPIN_HOST);

        $eyepinConnection->setUsername(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', ''));

        $eyepinConnection->setPassword(VA_EY4WP_Utility_Helper::decrypt(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', ''), AUTH_KEY));

        $langCode = substr(get_locale(),0,2);
        $values['lang'] = $langCode;




        foreach ($values as $k => $v) {
            $values[$k] = utf8_encode($v);
        }

        $values['status'] = 1;

        if ($form->opt_in == 'Ja') {

            $values['handleoptin'] = 1;

        } else {

            $values['handleoptin'] = 0;

        }

        //send post to eyepin


        $connectionResult = $eyepinConnection->sendCommand('AddressInsert', $values);


        //return error code if code is 4108 (= tried to update contact but overwrite_address is not enabled)
        if ($connectionResult == EYEPIN_CON_SUCCESS) {
            return true;
        } else if ($connectionResult == 4108){
            return $connectionResult;
        }

        return false;

    }


    /**
     * Send cf7 submit to eyepin
     * @global type $wpdb
     * @param type $values
     * @return boolean
     */

    public function submitCF7Address($data)
    {

        $eyepinConnection = new VA_EY4WP_Api_Eyepin();

        $eyepinConnection->setHost(self::EYEPIN_HOST);

        $eyepinConnection->setUsername(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', ''));

        $eyepinConnection->setPassword(VA_EY4WP_Utility_Helper::decrypt(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', ''), AUTH_KEY));


        $fields = array('email', 'title', 'salutation', 'firstname', 'lastname', 'street', 'zip', 'city', 'country', 'phone', 'fax',

            'mobile', 'internet', 'company', 'function', 'attribute1', 'attribute2', 'attribute3', 'attribute4', 'attribute5',

            'attribute6', 'attribute7', 'attribute8', 'attribute9', 'attribute10', 'attribute11', 'attribute12', 'attribute13',

            'attribute14', 'attribute15', 'attribute16', 'attribute17', 'attribute18', 'attribute19', 'attribute20');


        $values = array();

        foreach ($fields as $field) {

            if (isset($data[$field])) {

                $value = $data[$field];

                if ($value != NULL) {

                    $values[$field] = utf8_encode($value);

                }

            }

        }


        $values['status'] = 1;

        if ($data['eyepin_for_wp_integration'] == 'true') {

            $values['handleoptin'] = 1;

        } else {

            $values['handleoptin'] = 0;

        }


        //send post to eyepin

        $eyepinConnection->sendCommand('AddressInsert', $values);

        return true;

    }


    /**
     * Load accounts from eyepin
     * @return boolean
     */

    public function loadAccounts()
    {

        $eyepinConnection = new VA_EY4WP_Api_Eyepin();

        $eyepinConnection->setHost(self::EYEPIN_HOST);

        $eyepinConnection->setUsername(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_username', ''));

        $eyepinConnection->setPassword(VA_EY4WP_Utility_Helper::decrypt(get_option(VA_EY4WP_PLUGIN_NAME . '_eyepin_password', ''), AUTH_KEY));


        //load client data

        $connectionResult = $eyepinConnection->sendCommand('GetAccountInfo');

        if ($connectionResult == EYEPIN_CON_SUCCESS) {

            $clients = array();

            $response = $eyepinConnection->getResponse();

            foreach ($response->data->account->customers->customer as $client) {

                $clientArray = array(

                    'id' => $client['id'],

                    'name' => $client->name

                );


                array_push($clients, $clientArray);

            }


            if (count($clients) > 0) {

                return $clients;

            }

        } else {

            return array('-1');

        }

        return array('-');

    }


}

