<?php

/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

defined('ABSPATH') or die('No script kiddies please!');

class VA_EY4WP_Utility_Helper {

	/*
	public static function encrypt($input_string, $key) {
		$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
		$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
		$h_key = hash('sha256', $key, TRUE);
		return base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $h_key, $input_string, MCRYPT_MODE_ECB, $iv));
	}

	public static function decrypt($encrypted_input_string, $key) {
		$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
		$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
		$h_key = hash('sha256', $key, TRUE);
		return trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $h_key, base64_decode($encrypted_input_string), MCRYPT_MODE_ECB, $iv));
	}
	*/
	
	public static function encrypt($input_string, $key, $method='AES-256-CBC')
{
    $key = base64_decode($key);
    $iv_length = openssl_cipher_iv_length($method);
    $iv = openssl_random_pseudo_bytes($iv_length);
    $encrypted = openssl_encrypt($input_string, $method, $key,  OPENSSL_RAW_DATA, $iv);
    return base64_encode($iv.$encrypted);
}

public static function decrypt($encrypted_input_string, $key, $method='AES-256-CBC')
{
    $encrypted_input_string = base64_decode($encrypted_input_string);
    $key = base64_decode($key);
    $iv_length = openssl_cipher_iv_length($method);
    $iv = substr($encrypted_input_string, 0, $iv_length);
    $encrypted = substr($encrypted_input_string, $iv_length);
    return openssl_decrypt($encrypted, $method, $key,  OPENSSL_RAW_DATA, $iv);
}

    public static function checkPostAlreadyExported($postId) {
        global $wpdb;
        $table_name_exported = "{$wpdb->prefix}va_ey4wp_eyepin_exported";
        $exportedCount = $wpdb->get_var($wpdb->prepare(" SELECT count(id) FROM %i WHERE post_id = %d", $table_name_exported, $postId)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
        if ($exportedCount > 0) {
            return true;
        } else {
            return false;
        }
    }

    public static function getEyepinIdForPostId($postId) {
        global $wpdb;
        $table_name_exported = "{$wpdb->prefix}va_ey4wp_eyepin_exported";
        return $wpdb->get_var($wpdb->prepare(" SELECT eyepin_id FROM %i WHERE post_id = %d", $table_name_exported, $postId)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
    }

    public static function getFormForId($formId) {
        global $wpdb;
        $table_name = "{$wpdb->prefix}va_ey4wp_forms";
        return $wpdb->get_row($wpdb->prepare(" SELECT * FROM %i WHERE id = %d", $table_name, $formId)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery
    }

}
