<?php

/* * **************************************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Harald Holzmann <harald@varioous.at>, varioous OG
 *
 *  Eyepin For Wordpress is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  any later version.
 *   
 *  Eyepin For Wordpress is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Eyepin For Wordpress. If not, see http://www.gnu.org/copyleft/gpl.html.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************************************** */

class VA_EY4WP_Utility_Shortcodehandler
{

    /**
     * Get the user's IP address
     *
     * @return string The user's IP address
     */
    function get_user_ip_address() {
        if ( isset( $_SERVER['HTTP_CLIENT_IP'] ) && ! empty( sanitize_text_field(wp_unslash( $_SERVER['HTTP_CLIENT_IP'] )) ) ) {
            $IP = sanitize_text_field( wp_unslash( $_SERVER['HTTP_CLIENT_IP'] ) );
        } elseif ( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) && ! empty( sanitize_text_field(wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ) )) ) {
            $IP = sanitize_text_field( sanitize_text_field(wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] )) );
        } else {
            $IP = ( isset( $_SERVER['REMOTE_ADDR']  ) && ! empty( sanitize_text_field(wp_unslash( $_SERVER['REMOTE_ADDR']  ) )) ) ? sanitize_text_field( wp_unslash($_SERVER['REMOTE_ADDR'] )) : '';
        }
        return $IP;
    }

    public function display($id)
    {
        if(defined('REST_REQUEST')) return;
        $form = VA_EY4WP_Utility_Helper::getFormForId($id);
        $using_recaptcha_v3 = false;
        $secret_key = '';
        $is_using_recaptcha = false;

        if(!empty($form)) {
            $secret_key = $form->secret_key;
            $using_recaptcha_v3 = $form->re_captcha_version_type === 'v3';
        }

        if ($form != NULL) {
            $fields = array('email', 'title', 'salutation', 'firstname', 'lastname', 'street', 'zip', 'city', 'country', 'phone', 'fax',
                'mobile', 'internet', 'company', 'function', 'attribute1', 'attribute2', 'attribute3', 'attribute4', 'attribute5',
                'attribute6', 'attribute7', 'attribute8', 'attribute9', 'attribute10', 'attribute11', 'attribute12', 'attribute13',
                'attribute14', 'attribute15', 'attribute16', 'attribute17', 'attribute18', 'attribute19', 'attribute20');
            $eyepin_for_wp_nonce = isset($_POST['_eyepin_for_wp_nonce']) ? sanitize_key(wp_unslash($_POST['_eyepin_for_wp_nonce'])) : '';

            if(!empty($eyepin_for_wp_nonce) && wp_verify_nonce($eyepin_for_wp_nonce, 'handle_eyepin_for_wp_form')) {
                if (count($_POST) > 0 && isset($_POST['send'])) {
                    //handle form submit
                    $eyepin_for_wp_nonce = isset($_POST['_eyepin_for_wp_nonce']) ? sanitize_key(wp_unslash($_POST['_eyepin_for_wp_nonce'])) : '';
                    if (!isset($eyepin_for_wp_nonce) || !wp_verify_nonce($eyepin_for_wp_nonce, 'handle_eyepin_for_wp_form')) {
                        echo '<p class="error">' . esc_html($form->message_field_error) . '</p>';
                        exit;
                        return;
                    } else {

                        $values = array();
                        foreach ($fields as $field) {
                            $value = filter_input(INPUT_POST, $field);
                            if ($value != NULL) {
                                $values[$field] = $value;
                            }
                        }

                        $eyepinHelper = new VA_EY4WP_Utility_Eyepinhelper();
                        $ok = null;

                        if(!empty($_POST['g-recaptcha-response'])) {
                            $is_using_recaptcha = true;
                            $response = !empty($_POST['g-recaptcha-response']) ? sanitize_text_field(wp_unslash($_POST['g-recaptcha-response'])) : '';
                            $remote_ip = $this->get_user_ip_address(); // Assuming this method returns the user's IP
                            $ok = null;

                            // Prepare the URL with query parameters
                            $url = 'https://www.google.com/recaptcha/api/siteverify?secret=' . urlencode($secret_key) .
                                '&response=' . urlencode($response) .
                                '&remoteip=' . urlencode($remote_ip);

                            // Make the GET request
                            $response = wp_remote_get($url);

                            // Check for errors
                            if (is_wp_error($response)) {
                                // Handle the error
                                $ok = false;
                            } else {
                                // Decode the response
                                $result = json_decode(wp_remote_retrieve_body($response));

                                if ($using_recaptcha_v3) {
                                    $score = !empty($form->score) ? $form->score : 0.5;

                                    if ($result->success == true && $score <= $result->score) {
                                        $ok = $result->success;
                                    }
                                } else {
                                    $ok = $result->success;
                                }
                            }
                        } else {
                            $is_using_recaptcha = false;
                        }

                        if($ok || !$is_using_recaptcha) {
                            $submitResult = $eyepinHelper->submitAddress($values, $form);
                        } else {
                            $submitResult = 4109;
                        }

                        if ($submitResult === 4108) {
                            //error
                            echo '<p class="error">' . esc_html($form->message_field_already_exists) . '</p>';
                            return;

                        }  else if ($submitResult === 4109) {
                            //success
                            echo '<p class="error">' . esc_html($form->message_recaptcha_incorrect) . '</p>';
                            return;

                        }
                        else if ($submitResult) {
                            //success
                            echo '<p class="success">' . esc_html($form->message_sent) . '</p>';
                            return;

                        }
                        else {
                            //error
                            echo '<p class="error">' . esc_html($form->message_field_error) . '</p>';
                            return;
                        }
                    }
                }
            } else {

                $allowed_html = [
                    'div' => [
                        'id' => [],
                        'class' => [],
                        'data-sitekey' => [],
                        'data-callback' => [],
                        'data-size' => [],
                        'style' => []
                    ],
                    'fieldset' => [],
                    'select' => [
                        'name' => [],
                        'required' => [],
                        'class' => [],
                        'style' => []
                    ],
                    'option' => [
                        'value' => [],
                        'selected' => []
                    ],
                    'input' => [
                        'type'  => [],
                        'id'    => [],
                        'name'  => [],
                        'value' => [],
                        'checked'  => [],
                        'placeholder' => [],
                        'onclick' => [],
                        'required' => [],
                        'class' => [],
                        'style' => []
                    ],
                ];

                //display form
                echo "<form method='post' id='e-shortcode-form' action=''>";
                echo wp_kses(wp_nonce_field('handle_eyepin_for_wp_form', '_eyepin_for_wp_nonce'), $allowed_html);
                echo wp_kses($form->form ,$allowed_html);
                echo "<input type='submit' id='submit-btn' name='send' value='»'/>";
                echo "</form>";
            }
        } else {
            echo 'Das Formular existiert nicht!';
        }
    }
}
